// Mu-WinDlg.cpp : t@C
//

#include "stdafx.h"
#include "Mu-Win.h"
#include "Mu-WinDlg.h"
#include ".\mu-windlg.h"
#include "mckMain.h"
#include "dat00.h"
#include "dat01.h"
#include "emu2413/emu2413.cpp"
#include <math.h>

#include <mmsystem.h>
#pragma comment(lib,"winmm.lib")

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define FRate ((double)29.97 *2)
#define WRate 44100

int	Mch;	//`l

int	DISF = 2;//ʕ\^C~O␮
int VOL = 80;//}X^[{[
int PLLP = 2;//t[v񐔁ieconfigj
int PLLPC = 2;//t[v񐔁iہj
int FDTST;//tF[hAEgJn
int FDTED;//tF[hAEgI
int PEND;//tI
int VPSG = 100;//PSG
int VFM = 100;//FM
int VPCM = 100;//PCM
int CSTOP = 0;//I
int CMD = 0;//s
int COL = 0;//ʐF
int FMP4;//FM  f[^ 4bittO
int SQWF = 0;//`gϊ

int PSGEL[16][4] = {//PSG Gx[vp^[
	1,2,2,2,
	1,2,2,2,
	1,2,2,2,
	1,2,2,2,
	0,2,2,2,
	0,2,2,2,
	0,2,2,2,
	0,2,2,2,
	1,1,1,1,
	1,2,2,2,
	1,0,1,0,
	1,3,3,3,
	0,0,0,0,
	0,3,3,3,
	0,1,0,1,
	0,2,2,2};

int FMPAN[16][2];
int FMPANP[16][2] = {//FM p|bg
	0,0,
	3,0,
	3,0,
	0,4,//sAm
	0,3,
	0,3,
	0,3,//I[{G
	0,4,
	0,4,
	0,4,
	3,0,
	3,0,
	3,0,
	4,0,
	4,0,
	4,0};

int FMPAND[5][2];
int FMPANDP[5][2] = {//FM drum p|bg
	0,3,//36 L4 oX
	2,0,//37 H4 nCnbg
	0,2,//37 L4 XlA
	0,0,//38 H4 ^
	3,0};//38 L4 Vo

int PSGPAN[3][2];
int PSGPANP[3][2] = {//PSG p|bg
	100, 33,
	100,100,
	 33,100};

int PCMPAN[8][2];//PCM p|bg
int SQW[2] = {1,1};//* Square Wave Setting ( scc.fm )

void PTS( CWnd* ph );
CWnd* pWND;
BYTE CPY[384 *512 *3 +4];
int clk;//oߎ
int clkW;//oߎԁio̓^C~Oj
int cnt;//t[JEg
int cntE = 0;//vZItO (0:I 1/1000000b)

CString cFN[100000];
int FLen = 0;

#define WAVBS		8192						//WAVEOUTobt@Pʐ
#define ERRMS		4096						//G[bZ[WTCY
char		cEm[ERRMS];
BYTE		WVHD[64][sizeof( WAVEHDR )];		//WAVEOUTwb_[
BYTE		WVBF[2][WAVBS *4];					//WAVEOUTobt@
BYTE		WAVF[WRate *4 *60 *21];				//WAVobt@i21j
double		WAVM1[15700 *60 *21];				//WAV15700obt@i21j49716
double		WAVM2[15700 *60 *21];				//WAV15700obt@i21j49716
double*		pWAVM1 = &WAVM1[262 *2];
double*		pWAVM2 = &WAVM2[262 *2];
short int	WAVY1[49716 *60 *21];				//FMobt@i21j
short int	WAVY2[49716 *60 *21];				//FMobt@i21j
short int*	pWAVY1 = &WAVY1[2];
short int*	pWAVY2 = &WAVY2[2];
BYTE		DIS[60 *60 *21][20][6];				//\[4..]x20chi21j
BYTE		PSGN[0x20000];						//PSG mCYe[u
BYTE		PSGEV[16][0x4000];					//PSG Gx[v
BYTE		PSGVP[0x1000];						//PSG Gx[vʁiPg`j

HWAVEOUT	hWout;						//WaveOutnh
BYTE*		pWdata = &WAVF[0];			//WAVEtB[h
int			WDP;						//WAVEf[^ʒu
int			WLN;						//WAVEf[^
BYTE*		pWo0 = &WVBF[0][0];			//obt@0
BYTE*		pWo1 = &WVBF[1][0];			//obt@1
WAVEHDR*	pWh0[64];					//wb_0
WAVEHDR*	pWh1[64];					//wb_1
int			Whn;						//wb_ԍ
int			fPP = false;				//ttO
int			WPCT = 0;					//tIJEg (1/60bP)

static BYTE* MemP[256];
BYTE* MemA( int L );
CString FileR( BYTE*& pD , int& L , int F , CString cN );
CString FileW( BYTE* pD , int L , CString cN );
int TextS( BYTE* pP , int Len , CString cT , int* pF , int N );//txt.f[^..i[.i[
void WStop( void );
void SetWD( WAVEHDR* pWh );

int MMWV( int F , int& CT , CString cFN );//WAVf[^쐬 (1/60bP)
int GCMD( BYTE* pM , int& P , int C , int N );//R}h擾i-1: 0:擾 1:ǉj
int GCM4( BYTE* pM , int& P );//4rbgf[^擾
void WINT();//ʏ
void PRNT( int X , int Y , int C );
void PRNT2( int X , int Y , CString cC );
void PRTN( int Y , int N );//Օ\
void PRTV( int Y , int N );//ʕ\
void WTN( int N , BYTE* pP );//]

CString cTIT = "";						//^Cg

// CMuWinDlg _CAO



CMuWinDlg::CMuWinDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMuWinDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMuWinDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST2, m_list);
	DDX_Control(pDX, IDC_EDIT1, m_TIT);
	DDX_Control(pDX, IDC_CHECK1, m_WAV);
	DDX_Control(pDX, IDC_RADIO1, m_F0);
	DDX_Control(pDX, IDC_RADIO2, m_F1);
	DDX_Control(pDX, IDC_RADIO3, m_F2);
	DDX_Control(pDX, IDC_RADIO4, m_F3);
	DDX_Control(pDX, IDC_RADIO5, m_F4);
	DDX_Control(pDX, IDC_RADIO6, m_F5);
	DDX_Control(pDX, IDC_RADIO7, m_F6);
	DDX_Control(pDX, IDC_EDIT2, m_VOL);
	DDX_Control(pDX, IDC_EDIT3, m_LP);
	DDX_Control(pDX, IDC_EDIT4, m_PSG);
	DDX_Control(pDX, IDC_EDIT5, m_FM);
	DDX_Control(pDX, IDC_EDIT6, m_PCM);
	DDX_Control(pDX, IDC_CHECK2, m_SQW);
}

BEGIN_MESSAGE_MAP(CMuWinDlg, CDialog)
	ON_MESSAGE(MM_WOM_DONE,WvCB)

	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_WM_DROPFILES()
	ON_BN_CLICKED(IDC_BUTTON1, OnPLAY)
	ON_BN_CLICKED(IDC_BUTTON2, OnSTOP)
	ON_BN_CLICKED(IDC_BUTTON3, OnEND)
	ON_WM_DESTROY()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_RADIO1, On_F0)
	ON_BN_CLICKED(IDC_RADIO2, On_F1)
	ON_BN_CLICKED(IDC_RADIO3, On_F2)
	ON_BN_CLICKED(IDC_RADIO4, On_F3)
	ON_BN_CLICKED(IDC_RADIO5, On_F4)
	ON_BN_CLICKED(IDC_RADIO6, On_F5)
	ON_BN_CLICKED(IDC_RADIO7, On_F6)
	ON_BN_CLICKED(IDC_BUTTON4, OnCol)
	ON_BN_CLICKED(IDC_BUTTON5, OnNEXT)
END_MESSAGE_MAP()


// CMuWinDlg bZ[W nh

BOOL CMuWinDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	// TODO: ɒǉ܂B
	char N[256];
	CString cT;
   	DragAcceptFiles();

	int WAVEX = 1;
	int Clen;
	BYTE* pTdata;
	CString cEr = FileR( pTdata , Clen , 0x1000 , "Mu-Win_config.txt" );
	if( cEr == "" )
	{
		CString cF[9] = {
			"* WAV Export",
			"* Display Fix",
			"* Master Volume",
			"* Loop",
			"* PSG Volume",
			"* FM Volume",
			"* PCM Volume",
			"* Display Color",
			"* Square Wave Setting ( scc.fm )"};

		int* pF[9];
		pF[0] = &WAVEX;
		pF[1] = &DISF;
		pF[2] = &VOL;
		pF[3] = &PLLP;
		pF[4] = &VPSG;
		pF[5] = &VFM;
		pF[6] = &VPCM;
		pF[7] = &COL;
		pF[8] = &SQW[0];

		int N[9] = {1,1,1,1,1,1,1,1,2};

		for( int n=0 ; n<9 ; n++ )
		{
			int T = TextS( pTdata , Clen , cF[n] , pF[n] , N[n] );
			if( T == 0 )
			{
				if( true ) continue;
				else
				{
					cEr = "ݒ荀ڂt܂ : configuration item not found : " + cF[n];
					break;
				}
			}
			if( T == 1 )
			{
				cEr = "ݒ萔sĂ܂ : not enough settings : " + cF[n];
				break;
			}
		}
		if( cEr != "" )
		{
			MessageBox( cEr , NULL , MB_OK );
			OnOK();
		}
	}
	if( WAVEX ) m_WAV.SetCheck( 1 );
	if( DISF < 0 || DISF > 6 ) DISF = 2;
	COL %= 3;
	//ʕ\^C~O␮
	if( DISF == 0 ) m_F0.SetCheck( 1 );
	if( DISF == 1 ) m_F1.SetCheck( 1 );
	if( DISF == 2 ) m_F2.SetCheck( 1 );
	if( DISF == 3 ) m_F3.SetCheck( 1 );
	if( DISF == 4 ) m_F4.SetCheck( 1 );
	if( DISF == 5 ) m_F5.SetCheck( 1 );
	if( DISF == 6 ) m_F6.SetCheck( 1 );
	cT = itoa( VOL , N , 10 );
	m_VOL.SetWindowText( cT );//
	cT = itoa( PLLP , N , 10 );
	m_LP.SetWindowText( cT );//t[v
	cT = itoa( VPSG , N , 10 );
	m_PSG.SetWindowText( cT );//PSG
	cT = itoa( VFM , N , 10 );
	m_FM.SetWindowText( cT );//FM
	cT = itoa( VPCM , N , 10 );
	m_PCM.SetWindowText( cT );//PCM

	for( int i=0 ; i<64 ; i++ )
	{
		pWh0[i] = (WAVEHDR*)&WVHD[i + 0][0];
		pWh1[i] = (WAVEHDR*)&WVHD[i +32][0];
	}
	WINT();

	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CMuWinDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
		PTS( GetDlgItem( IDC_PIC ) );
		pWND = GetDlgItem( IDC_PIC );
	}
}

//[U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CMuWinDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CALLBACK EXPORT TimProc( HWND hWnd , UINT nMsg , UINT nIDEvent , DWORD dwTime )
{
	if( WPCT-- < 0 )
	{
		if( fPP ) WStop();
	}
	if( cntE > 0 )
	{
		cntE = MMWV( (int)((double)15000 / (double)cntE *0.75) +1 , cnt , "" );
		int F1 = (int)((double)cnt * (double)WRate / FRate);
		WLN = F1 *4 +0x2c;
		ZeroMemory( &WAVF[WLN] , 0x10000 );
	}
	int S = clock() - clkW;
	if( clkW < 0 ) S = 0;
	S = (int)((double)S * (double)WRate /1000.0 +(double)(DISF -3) /10 * (double)WRate) *4 - WAVBS *4 + WDP;
	if( S < 0x2c ) S = 0x2c;
	for( int i=0 ; i<57 ; i++ )
	{
		PRNT2( i +22 , 0 , " " );
		PRNT2( i +22 , 1 , " " );
	}
	for( int i=0 ; i<342 ; i++ )
	{
		int V = (*(short int*)(pWdata + S + i *2 *4) + *(short int*)(pWdata + S + i *2 *4 +2)) /2 *16 /32768;
		int P = (i +22 *6 +16) *3 +16 *512 *3;
		if( V > 0 )
		{
			for( int j=0 ; j<V ; j++ )
			{
				for( int k=0 ; k<3 ; k++ ) CPY[P - j *512 *3 + k] = 0xf7;
			}
		}
		else
		{
			for( int j=0 ; j<-V ; j++ )
			{
				for( int k=0 ; k<3 ; k++ ) CPY[P + j *512 *3 + k] = 0xf7;
			}
		}
	}
	S = (int)((double)(S -0x2c) * FRate / WRate /4.0);
	if( S >= cnt ) S = cnt -1;
	for( int i=0 ; i<20 ; i++ )
	{
		CString cT = "";
		for( int j=0 ; j<4 ; j++ ) cT += (char)DIS[S][i][j];
		PRNT2( 0 , i +3 , cT );
		PRTV( i +3 , DIS[S][i][4] );
		PRTN( i +3 , DIS[S][i][5] );
	}
	CString cT = "";
	char N[256];
	S = (int)((double)S *60.0 / FRate);
	int T = (int)((double)S / 60.0);
	itoa( T /60 +1000 , N , 10 );
	cT += N[1];
	cT += N[2];
	cT += N[3];
	cT += ':';
	itoa( (T %60) +100 , N , 10 );
	cT += N[1];
	cT += N[2];
	cT += ':';
	itoa( (S %60) *100 /60 +100 , N , 10 );
	cT += N[1];
	cT += N[2];
	PRNT2( 2 , 1 , cT );
	PTS( pWND );
}

void CMuWinDlg::OnDropFiles(HDROP hDropInfo)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	int L = m_list.GetItemHeight( 0 );
	for( int i=0 ; i<10000 ; i++ ) m_list.DeleteString( 0 );

	FLen = DragQueryFile(hDropInfo,-1, NULL,0);
	if( FLen >= 10000 )
	{
		MessageBox( "t@C߂܂" , NULL , MB_OK );
	}
	else
	{
		for( i=0 ; i<FLen ; i++ )
		{
			int L = DragQueryFile(hDropInfo,i, NULL,0);
			DragQueryFile( hDropInfo , i , cFN[i].GetBuffer( L +1 ) , L +1 );
			cFN[i].ReleaseBuffer();
			m_list.AddString( cFN[i] );
		}
	}

	CDialog::OnDropFiles(hDropInfo);
}

void CMuWinDlg::OnPLAY()
{
	if( CMD ) return;

	LARGE_INTEGER QPF;			//QueryPerformanceFrequency
	if( !QueryPerformanceFrequency( &QPF ) )
	{
		MessageBox( "Ԃ̌vł܂ ( \ptH[}XJE^T|[gĂ܂ ) : can't measure time" , NULL , MB_ICONEXCLAMATION | MB_OK );
		return;
	}
	{	//PSG mCYe[u
		int PNR = 1;
		for( int i=0 ; i<0x20000 ; i++ )
		{
			PSGN[i] = PNR &1;
			PNR = (PNR >> 1) ^ ((PNR & 1) << 13) ^ ((PNR & 1) << 16);
		}
		//PSG Gx[vʁiPg`j
		for( int i=1 ; i<0x1000 ; i++ ) PSGVP[i] = (BYTE)(double)pow( (double)1.0013547198921082058808815267841 , (double)i );
		PSGVP[0] = 0;
		for( int i=0 ; i<16 ; i++ )
		{
			for( int j=0 ; j<4 ; j++ )
			{
				int F = PSGEL[i][j];
				if( F == 0 ) for( int k=0 ; k<4096 ; k++ ) PSGEV[i][j *4096 + k] = PSGVP[k];
				if( F == 1 ) for( int k=0 ; k<4096 ; k++ ) PSGEV[i][j *4096 + k] = PSGVP[4095 - k];
				if( F == 2 ) for( int k=0 ; k<4096 ; k++ ) PSGEV[i][j *4096 + k] = 0;
				if( F == 3 ) for( int k=0 ; k<4096 ; k++ ) PSGEV[i][j *4096 + k] = 255;
			}
		}
	}

	ZeroMemory( &cEm[0] , sizeof( cEm ) );
	for( int n=0 ; n<FLen ; n++ )
	{
		CMD = 1;
		WStop();
		KillTimer( 2 );
		cntE = 0;
		ZeroMemory( &DIS[0][0][0] , sizeof( DIS ) );//\

		//t@C擾
		CString				cEr;							//G[bZ[W
		CString				cSF;	//t@C
		CString				cT;
		int					T;

		m_VOL.GetWindowText( cT );
		VOL = atoi( cT );
		if( VOL < 0 || VOL > 500 )
		{
			cEr = "}X^[{[͈͊Oł ( 0-500 ) : Master volume out of range";
			for( T=0 ; T<cEr.GetLength() ; T++ ) cEm[T] = cEr[T];
			break;
		}
		m_LP.GetWindowText( cT );
		PLLP = atoi( cT );
		if( PLLP < 0 || PLLP > 20 )
		{
			cEr = "[v񐔂͈͊Oł ( 0-20 ) : Loop count out of range";
			for( T=0 ; T<cEr.GetLength() ; T++ ) cEm[T] = cEr[T];
			break;
		}
		m_PSG.GetWindowText( cT );
		VPSG = atoi( cT );
		if( VPSG < 0 || VPSG > 500 )
		{
			cEr = "PSGʂ͈͊Oł ( 0-500 ) : PSG volume out of range";
			for( T=0 ; T<cEr.GetLength() ; T++ ) cEm[T] = cEr[T];
			break;
		}
		m_FM.GetWindowText( cT );
		VFM = atoi( cT );
		if( VFM < 0 || VFM > 500 )
		{
			cEr = "FMʂ͈͊Oł ( 0-500 ) : FM volume out of range";
			for( T=0 ; T<cEr.GetLength() ; T++ ) cEm[T] = cEr[T];
			break;
		}
		m_PCM.GetWindowText( cT );
		VPCM = atoi( cT );
		if( VPCM < 0 || VPCM > 500 )
		{
			cEr = "PCMʂ͈͊Oł ( 0-500 ) : PCM volume out of range";
			for( T=0 ; T<cEr.GetLength() ; T++ ) cEm[T] = cEr[T];
			break;
		}

		T = 0;
		while( true )
		{
			cT = cFN[n];
			cT = cT.Right( 3 );
			cT.MakeLower();
			if( cT == ".mu" )
			{
				cSF = cFN[n].Left( cFN[n].GetLength() -3 );
				break;
			}
			cT = cFN[n];
			cT = cT.Right( 4 );
			cT.MakeLower();
			if( cT == ".wav" )
			{
				cSF = cFN[n].Left( cFN[n].GetLength() -4 );
				break;
			}
			if( cT == ".txt" )
			{
				cSF = cFN[n].Left( cFN[n].GetLength() -4 );
				break;
			}
			T = 1;
			break;
		}
		if( T ) continue;
		cFN[n] = cSF +".mu";

		//
		SQWF = m_SQW.GetCheck();
		MakeTable2();
		MakeTable4();
		ZeroMemory( &WAVF[0x2c] , WRate *2 );
		cnt = 0;
		MMWV( 0 , cnt , cFN[n] );
		if( cEm[0] ) break;
		m_TIT.SetWindowText( cTIT );

		PLLPC = PLLP;
		FDTST = 9999;
		FDTED = 5;

		CopyMemory( &FMPAN[0][0] , &FMPANP[0][0] , sizeof( FMPANP ) );
		CopyMemory( &FMPAND[0][0] , &FMPANDP[0][0] , sizeof( FMPANDP ) );
		CopyMemory( &PSGPAN[0][0] , &PSGPANP[0][0] , sizeof( PSGPANP ) );
		T = (Mch +1) >> 1;
		for( int i=0 ; i<T ; i++ )
		{
			int S = T -1;
			if( S == 0 ) S = 1;
			int F = 30 + 70 * i / S;
			PCMPAN[i][0] = 100;
			PCMPAN[i][1] = F;
			PCMPAN[Mch -1 - i][0] = F;
			PCMPAN[Mch -1 - i][1] = 100;
		}
		{
			BYTE* pTdata;
			int Clen;
			cEr = FileR( pTdata , Clen , 0x1000 , cSF +".txt" );
			if( cEr == "" )
			{
				CString cF[7] = {
					"* PSG PAN",
					"* FM PAN",
					"* FM DRUMS PAN",
					"* PCM PAN",
					"* Loop",
					"* Fade out start time",
					"* Fade out time"};

				int* pF[7];
				pF[0] = &PSGPAN[0][0];
				pF[1] = &FMPAN[0][0];
				pF[2] = &FMPAND[0][0];
				pF[3] = &PCMPAN[0][0];
				pF[4] = &PLLPC;
				pF[5] = &FDTST;
				pF[6] = &FDTED;
				int N[7] = {6,32,10,16,1,1,1};

				for( int n=0 ; n<7 ; n++ )
				{
					T = TextS( pTdata , Clen , cF[n] , pF[n] , N[n] );
					if( T == 0 )
					{
						if( true ) continue;
						else
						{
							cEr = "ݒ荀ڂt܂ : configuration item not found : " + cF[n];
							break;
						}
					}
					if( T == 1 )
					{
						cEr = "ݒ萔sĂ܂ : not enough settings : " + cF[n];
						break;
					}
				}
				if( cEr != "" )
				{
					for( T=0 ; T<cEr.GetLength() ; T++ ) cEm[T] = cEr[T];
					break;
				}
			}
			cEr = "";
		}
		PEND = (FDTST + FDTED) *60;
		if( PEND >= 60 *60 *20 ) PEND = 60 *20 *20;//Œ20

		cntE = MMWV( 60 , cnt , "" );
		clk = clock();
		SetTimer( 2 , 16 , TimProc );

		CSTOP = 0;//Iݒ

		//WAVEf[^
		int					Wch = 2;						//mono - stereo
		int					Wrat = WRate;					//WAVE[g
		int					Wbit = 16;						//WAVErbg
		int					Wus = Wch * Wbit /8;			//WAVEPʒ

		*(int*) &pWdata[ 0] = 'FFIR';							//'RIFF'
//		*(int*) &pWdata[ 4] = WCc *2 +0x2c -8;
		*(int*) &pWdata[ 8] = 'EVAW';							//'WAVE'
		*(int*) &pWdata[12] = ' tmf';							//'fmt '
		*(int*) &pWdata[16] = 0x10;
		*(WORD*)&pWdata[20] = 1;
		*(WORD*)&pWdata[22] = 2;
		*(WORD*)&pWdata[24] = Wrat;
		*(WORD*)&pWdata[26] = 0;
		*(int*) &pWdata[28] = Wrat *4;
		*(WORD*)&pWdata[32] = 0x2;
		*(WORD*)&pWdata[34] = 0x10;
		*(int*) &pWdata[36] = 'atad';							//'data'
//		*(int*) &pWdata[40] = WCc *2;

		int F1 = (int)((double)cnt * (double)WRate / FRate);
		WLN = F1 *4 +0x2c;
		ZeroMemory( &WAVF[WLN] , 0x10000 );
		ZeroMemory( &WVBF[0][0] , sizeof( WVBF ) );
		WDP = 0x2c;

		//Đ
		WAVEFORMATEX	sPF;						//obltH[}bg
		MMRESULT		rMR;						//߂l
		WAVEHDR			*pW0,*pW1;

		sPF.wFormatTag = WAVE_FORMAT_PCM;
		sPF.nChannels = Wch;
		sPF.wBitsPerSample = Wbit;
		sPF.nBlockAlign = Wus;
		sPF.nSamplesPerSec = Wrat;
		sPF.nAvgBytesPerSec = Wrat * Wus;
		if( (rMR = waveOutOpen( (LPHWAVEOUT)&hWout , WAVE_MAPPER , (LPWAVEFORMATEX)&sPF , (DWORD_PTR)GetSafeHwnd() , 0 , CALLBACK_WINDOW )) != MMSYSERR_NOERROR ) goto Er4;
		Whn = (Whn +1) &7;
		pW0 = pWh0[Whn];
		pW1 = pWh1[Whn];
		pW0->lpData = (LPSTR)pWo0;
		pW0->dwBufferLength = Wus * WAVBS;
		pW0->dwFlags = 0;
		pW0->dwLoops = 0;
		pW1->lpData = (LPSTR)pWo1;
		pW1->dwBufferLength = Wus * WAVBS;
		pW1->dwFlags = 0;
		pW1->dwLoops = 0;
		if( (rMR = waveOutPrepareHeader( hWout , pW0 , sizeof( WAVEHDR ) )) != MMSYSERR_NOERROR ) goto Er3;
		if( (rMR = waveOutPrepareHeader( hWout , pW1 , sizeof( WAVEHDR ) )) != MMSYSERR_NOERROR ) goto Er2;
		SetWD( pW0 );
		SetWD( pW1 );
		if( (rMR = waveOutWrite( hWout , pW0 , sizeof( WAVEHDR ) )) != MMSYSERR_NOERROR ) goto Er1;
		if( (rMR = waveOutWrite( hWout , pW1 , sizeof( WAVEHDR ) )) != MMSYSERR_NOERROR )
		{
Er1:		waveOutUnprepareHeader( hWout , pW1 , sizeof( WAVEHDR ) );
Er2:		waveOutUnprepareHeader( hWout , pW0 , sizeof( WAVEHDR ) );
Er3:		waveOutClose( hWout );
Er4:		waveOutGetErrorText( rMR , (LPSTR)cEm , ERRMS );
			break;
		}
		fPP = true;
		WPCT = 60 *60 *60 *2;//ŒQ
		while( cntE > 0 )
		{
			if( CSTOP ) break;
			MSG msg;
			while( ::PeekMessage( &msg , NULL , 0 , 0 , PM_NOREMOVE ) )
			{
				if( !AfxGetApp() -> PumpMessage() )
				{
					::PostQuitMessage( 0 );
					break;
				}
			}
		}
		MMWV( -1 , cnt , "" );
		if( CSTOP == 1 ) break;
		CSTOP = 0;

		//f[^̏
		*(int*) &pWdata[ 4] = WLN -8;
		*(int*) &pWdata[40] = WLN -0x2c;
		if( m_WAV.GetCheck() )
		{
			if( cntE == 0 )
			{
				if( (cEr = FileW( pWdata , WLN , cSF +".wav" )) != "" )
				{
					for( T=0 ; T<cEr.GetLength() ; T++ ) cEm[T] = cEr[T];
					break;
				}
			}
		}
		MemA( 0 );

		while( fPP )
		{
			if( m_WAV.GetCheck() ) break;
			if( CSTOP ) break;
			MSG msg;
			while( ::PeekMessage( &msg , NULL , 0 , 0 , PM_NOREMOVE ) )
			{
				if( !AfxGetApp() -> PumpMessage() )
				{
					::PostQuitMessage( 0 );
					break;
				}
			}
		}
		if( CSTOP == 1 ) break;
	}
	if( cEm[0] )
	{
		WStop();
		KillTimer( 2 );
		cntE = -1;
		MMWV( -1 , cnt , "" );
		WStop();
		MessageBox( cEm , NULL , MB_ICONEXCLAMATION | MB_OK );
	}
	MemA( 0 );
	CMD = 0;
}

void CMuWinDlg::OnSTOP()
{
	CSTOP = 1;
	WStop();
	KillTimer( 2 );
	if( cntE > 0 ) cntE = -1;
	MMWV( -1 , cnt , "" );
	MemA( 0 );
}

void CMuWinDlg::OnNEXT()
{
	CSTOP = 2;
	WStop();
	KillTimer( 2 );
	if( cntE > 0 ) cntE = -1;
	MMWV( -1 , cnt , "" );
	MemA( 0 );
}

void CMuWinDlg::OnEND()
{
	CSTOP = 1;
	WStop();
	KillTimer( 2 );
	cntE = -1;
	MMWV( -1 , cnt , "" );
	MemA( 0 );
	OnOK();
}


void CMuWinDlg::OnClose()
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	CSTOP = 1;
	WStop();
	KillTimer( 2 );
	cntE = -1;
	MMWV( -1 , cnt , "" );
	MemA( 0 );

	CDialog::OnClose();
}

void CMuWinDlg::OnDestroy()
{
	CDialog::OnDestroy();

	// TODO : ɃbZ[W nh R[hǉ܂B
	CSTOP = 1;
	WStop();
	KillTimer( 2 );
	MMWV( -1 , cnt , "" );
	cntE = -1;
	MemA( 0 );
}

BYTE* MemA( int L )
{
	static int S = 0;
	if( L ) return( MemP[S++] = (BYTE*)GlobalAlloc( GMEM_FIXED , L ) );
	while( S )
	{
		::GlobalFree( MemP[--S] );
		MemP[S] = NULL;
	}
	return( NULL );
}

CString FileR( BYTE*& pD , int& L , int F , CString cN )
{
	CFileException	FErr;
	CFile			cDfile;
	if( !cDfile.Open( cN , CFile::modeRead , &FErr ) )
	{
		if( FErr.m_cause == CFileException::fileNotFound ) return( cN + " : file not found : t@C܂" );
		return( "file cannot open : t@CI[vł܂" );
	}
	L = (int)cDfile.GetLength();
	if( (pD = MemA( L + F )) == NULL ) return( "memory error : mۂł܂ł" );
	CString cT = ((int)cDfile.Read( pD , L ) == L) ? "" : "ǍG[" ;
	cDfile.Close();
	for( int i=0 ; i<F ; i++ ) pD[L + i] = 0;
	return( cT );
}

CString FileW( BYTE* pD , int L , CString cN )
{
	CFile	cDfile;
	if( !cDfile.Open( cN , CFile::modeCreate | CFile::modeWrite , NULL ) ) return( "could not create file : t@C쐬ł܂ł" );
	cDfile.Write( pD , L );
	cDfile.Close();
	return( "" );
}

int TextS( BYTE* pP , int Len , CString cT , int* pF , int N )//txt.f[^..i[.i[
{
	int L = cT.GetLength();
	int P = 0;
	int F = 1;
	while( P < Len )
	{
		int N;
		for( N=0 ; N<L ; N++ )
		{
			if( pP[P + N] != (BYTE)cT[N] ) break;
		}
		if( N == L )
		{
			F = 0;
			break;
		}
		P++;
	}
	if( F ) return( 0 );

	P += 8;
	for( int i=0 ; i<N ; i++ )
	{
		F = 1;
		while( P < Len )
		{
			if( pP[P] >= '0' && pP[P] <= '9' )
			{
				F = 0;
				break;
			}
			if( pP[P] == '*' ) break;
			P++;
		}
		if( F ) return( 1 );
		F = 0;
		while( P < Len )
		{
			int T = pP[P++];
			if( T < '0' || T > '9' ) break;
			F = F *10 + T -'0';
		}
		pF[i] = F;
	}
	return( 2 );
}

void WStop( void )
{
	int fT = fPP;

	fPP = false;
	if( fT == false ) return;
	waveOutReset( hWout );
	waveOutUnprepareHeader( hWout , pWh0[Whn] , sizeof(WAVEHDR) );
	waveOutUnprepareHeader( hWout , pWh1[Whn] , sizeof(WAVEHDR) );
	waveOutClose( hWout );
}

void SetWD( WAVEHDR* pWh )
{
	int L = pWh->dwBufferLength;
	if( WDP < WLN )
	{
		CopyMemory( (BYTE*)pWh->lpData , pWdata + WDP , L );
		WDP += L;
		clkW = clock();
	}
	else
	{
		ZeroMemory( (BYTE*)pWh->lpData , L );
		clkW = -1;
		if( WPCT > 30 ) WPCT = 30;//0.5bҋ@
	}
}

LRESULT CMuWinDlg::WvCB(WPARAM wParam,LPARAM lParam)
{
	MMRESULT		rMR;						//߂l

	if( fPP == false || ((WAVEHDR*)lParam != pWh0[Whn] && (WAVEHDR*)lParam != pWh1[Whn]) ) return( 0 );

	SetWD( (WAVEHDR*)lParam );
	if( (rMR = waveOutWrite( (HWAVEOUT)wParam , (WAVEHDR*)lParam , sizeof( WAVEHDR ) )) != MMSYSERR_NOERROR )
	{
		waveOutGetErrorText( rMR , (LPSTR)cEm , ERRMS );
		WStop();
		MessageBox( cEm , NULL , MB_OK | MB_ICONEXCLAMATION );
	}
	return( 0 );
}

void PTS( CWnd* ph )
{
	{
		int P[4] = {0x2020f7,0x202020,0x202020};
		int Q[4] = {0xf7f7f7,0xf7f7f7,0x20f720};
		int C[2];
		C[0] = P[COL];
		C[1] = Q[COL];
		BYTE* pP = &CPY[0];
		for( int i=0 ; i<384 ; i++ )
		{
			for( int j=0 ; j<512 ; j++ )
			{
				*(int*)pP = C[pP[1] >> 7];
				pP += 3;
			}
		}
	}
	BYTE BMI[sizeof( BITMAPINFO )];
	CDC* pDC = ph->GetDC();

	CRect R;
	ph->GetClientRect( &R );
	int X0 = R.left;
	int Y0 = R.top;
	int X1 = R.right;
	int Y1 = R.bottom;

	ZeroMemory( &BMI[0] , sizeof( BITMAPINFO ) );
	BITMAPINFO* pF = (BITMAPINFO*)&BMI[0];
	pF->bmiHeader.biSize = sizeof( BITMAPINFO );
	int X = X1 - X0;
	int Y = Y1 - Y0;
	int S = 2;
	for( int i=1 ; i<=40 ; i++ )
	{
		if( abs( X -256 * i ) <= 2 * i )
		{
			X = 256 * i;
			S = i;
		}
		if( abs( Y -192 * i ) <= 2 * i )
		{
			Y = 192 * i;
			S = i;
		}
	}
	pF->bmiHeader.biWidth = 512;
	pF->bmiHeader.biHeight = 384;
	pF->bmiHeader.biPlanes = 1;
	pF->bmiHeader.biBitCount = 24;
	StretchDIBits( pDC->GetSafeHdc() , 0 , Y , X , -Y , 0 , 0 , 512 , 384 , &CPY[0] , pF , DIB_RGB_COLORS , SRCCOPY );

	CString cT = "OK";
	if( cntE ) cT = "--";
	pDC->TextOut( X1 +4 * S , 0 , cT );

	ph->ReleaseDC( pDC );
}

int GCMD( BYTE* pM , int& P , int C , int N )
{
	static int S,F;
	static BYTE SP[4096];
	if( C < 0 )
	{
		S = F = 0;
		return( 0 );
	}
	if( C )
	{
		SP[(F + S++) &4095] = N;
		return( 0 );
	}
	if( S )
	{
		S--;
        return( SP[F++ &4095] );
	}
	return( pM[P++] );
}

int GCM4( BYTE* pM , int& P )
{
	static int D;
	if( FMP4 == 0 )
	{
		FMP4 = 1;
		D = pM[P++];
		return( D >> 4 );
	}
	FMP4 = 0;
	return( D &15 );
}

void WINT()
{
	char N[256];
	CString cT = "";
	itoa( VOL +1000 , N , 10 );
	cT += (char)N[1];
	cT += (char)N[2];
	cT += (char)N[3];
	for( int i=0 ; i<24 ; i++ )
	{
		for( int j=0 ; j<85 ; j++ ) PRNT( j *6 , i *16 , ' ' );
		PRNT( 506 , i *16 , ' ' );
	}
	PRNT2( 0 , 0 , "| mu-player win 1.17 |" );
	PRNT2( 0 , 1 , "| 000:00:00 vol 100% |" );
	PRNT2( 16 , 1 , cT );
	for( int i=0 ; i<80 ; i++ ) PRNT2( i , 2 , "-" );
	PRNT2( 79 , 0 , "|" );
	PRNT2( 79 , 1 , "|" );
	for( int i=3 ; i<23 ; i++ ) PRTN( i , -1 );
}

void PRNT( int X , int Y , int C )
{
	int XX = (630 *3 +3) &0xfffc;
	if( C > 0 && C < 10 +1 ) C += 95 -1;
	else
	{
		C -= ' ';
		if( C < 0 ) C = 0;
		if( C > 95 ) C = 0;
	}
	for( int y=0 ; y<16 ; y++ )
	{
		int P = (Y + y) *512 *3 + X *3;
		CopyMemory( &CPY[P] , &CHR00[(15 - y) * XX + C *6 *3 +0x36] , 6 *3 );
	}
}

void PRNT2( int X , int Y , CString cC )
{
	for( int i=0 ; i<cC.GetLength() ; i++ )
	{
		PRNT( X++ *6 +16 , Y *16 , cC[i] );
	}
}

void PRTN( int Y , int N )
{
	int F[12] = {0,1,0,1,0,0,1,0,1,0,1,0};
	for( int i=0 ; i<72 ; i++ )
	{
		int T = F[i %12] +1;
		if( i == N ) T += 2;
		PRNT( i *6 +16 +48 , Y *16 , T );
	}
}

void PRTV( int Y , int N )
{
	int S[7] = {32,5,6,7,8,9,10};
	CString cT = "";
	if( N == 0 ) N = 1;
	for( int i=0 ; i<4 ; i++ )
	{
		int T = N;
		if( T > 6 ) T = 6;
		cT += (char)S[T];
		N -= T;
	}
	PRNT2( 4 , Y , cT );
}

void WTN( int N , BYTE* pP )
{
	CString cN = "c c+d d+e f f+g g+a a+b ";
	if( N < 0 || N >= 12 *9 )
	{
		*pP++ = '-';
		*pP++ = '-';
		*pP++ = '-';
		*pP++ = '-';
		return;
	}
	*pP++ = 'o';
	*pP++ = '0' + N /12;
	N %= 12;
	*pP++ = cN[N *2];
	*pP++ = cN[N *2 +1];
}

int MMWV( int F , int& CT , CString cFN )//WAVf[^쐬 (1/60bP)
{
	CString				cEr;							//G[bZ[W
	CString cT;
	int T;

	//Muf[^
	static BYTE*				pM;								//Mut@C
	static BYTE*				pMP;							//MuPt@C
	static int					Mlen;							//f[^
	static int					P;								//f[^ʒu
	static int					PS;								//f[^ʒuif[^nj
	static int					LP;								//[v

	static int					Mver;							//o[W
	static int					Mvol;							//
	static int					Mve;							//ʕ␮W
	static int					Msel;							//Ii0:ώg 1:Œgj
	static int					Mvar;							//ώg Ii0:g`[h 1:TvO[hj
	static int					Mrst;							//Zbg
	static int					Msn;							//TvO`
	static int					MPl[256];						//TvO ef[^
	static int					MPt[256];						//TvO eK
	static int					MPf[256];						//TvO eiώg(FFh)/Œg(miol)j
	static BYTE					MPn[256][4];					//TvO e
	static int					MPp[256];						//TvO ef[^ʒu
	static BYTE					MPm[0x100000];					//TvO }bv
	static int					Msv = 0x0f;						//F
	static int					MDp[0x100];						//if[^ʒuj
	static int					MDl[0x100];						//if[^j
	static BYTE					MDd[0x2000];					//if[^j

	static int					WV24[8][8];						//ADPCMlۑ
	static int					WVFX[8][7];						//Œg:.f[^ԍ.f[^ʒu.Đʒu.e[uʒu(4 or 2).g`l.݌vJEg
	static OPLL					*pFM1,*pFM2;					//ym2413
	static int					fFM = 0;						//ym2413gptO
	static int					PSG[0x10];						//psg WX^
	static double				PSGV[0x10];						//psg 
	static double				PSGP[3];						//psg g`ʒu
	static double				PSGNP[3];						//psg g`ʒuimCYj
	static double				dPEP;							//psg Gx[vʒu
	static int					PSGEN;							//psg Gx[vԍ
	static int					PNP;							//psg mCYe[uʒu
	static int					PSGF;							//psg g`ZbgtO
	static int					FM[0x40];						//FM WX^
	static int					FMR[0x10];						//FM ĔtO
	static int					FMV[0x10];						//FM Ĕʁi\pj
	static int					FMRP[0x10];						//FM ĔtOippj
	static int					FMRN[0x10];						//FM pF
	static int					PCMV[8],PCMV2[8],PCMD[8];		//PCM .XVO.\p
	static int					PCMF[8],PCMF2[8];				//PCM gWX^.XVO
	static int					PCMN[8],PCMN2[8];				//PCM F.XVO
	static int					PCMP[8];						//PCM g`ʒu(0-255)
	static long long int		PCMP2[8];						//PCM g`ʒu(TvOp)
	static double				WVT1[4][810 *2];				//PCM 1/30bێ
	static double				WVT2[4][810 *2];				//PCM 1/30bێ
	static int					FMP;							//FM kichj
	static int					FMVC;							//FM 

	if( F == 0 )
	{
		//ʏ
		WINT();
		cT = cFN.Left( cFN.GetLength() -3 );
		cT = cT.Right( 16 );
		for( T=cT.GetLength()-1 ; T>=0 ; T-- )
		{
			if( cT[T] == '\\' ) break;
		}
		cT = cT.Right( cT.GetLength() - T -1 );
		cT = cT +"        ";
		cT = cT.Left( 8 );
		cT = cT.MakeUpper();
		PRNT2( 0 , 23 , cT );

		//
		for( T=0 ; T<4 ; T++ )
		{
			for( int i=0 ; i<810 *2 ; i++ ) WVT1[T][i] = WVT2[T][i] = 0.0;
		}
		for( T=0 ; T<262 *2 ; T++ ) WAVM1[T] = WAVM2[T] = 0.0;
		for( T=0 ; T<64 ; T++ ) WV24[T /8][T &7] = 0x8000;
		ZeroMemory( &WVFX[0][0] , sizeof( WVFX[0][0] ) );
		Mrst = 0xff;

		//ym2413.PSG 
		WAVY1[0] = WAVY1[1] = 0;
		WAVY2[0] = WAVY2[1] = 0;
		pFM1 = OPLL_new( 3579545 , 49716 );
		pFM2 = OPLL_new( 3579545 , 49716 );
		OPLL_reset( pFM1 );
		OPLL_reset( pFM2 );
		fFM = 1;
		PNP = 0;
		PSGF = 0;
		dPEP = 8192.0;
		PSGEN = 0;

		//WX^
		ZeroMemory( &PSG[0] , sizeof( PSG ) );
		PSG[7] = 0xb8;
		ZeroMemory( &FM[0] , sizeof( FM ) );
		ZeroMemory( &FMR[0] , sizeof( FMR ) );
		ZeroMemory( &FMV[0] , sizeof( FMV ) );
		ZeroMemory( &FMRP[0] , sizeof( FMRP ) );//FM ĔtOippj
		ZeroMemory( &FMRN[0] , sizeof( FMRN ) );//FM pF
		PSGV[0] = 0.0;
		for( int i=1 ; i<16 ; i++ ) PSGV[i] = (double)pow( (double)1.41421356 , (double)i );
		PSGP[0] = PSGP[1] = PSGP[2] = 0.0;
		PSGNP[0] = PSGNP[1] = PSGNP[2] = 0.0;
		ZeroMemory( &PCMV[0] , sizeof( PCMV ) );
		ZeroMemory( &PCMV2[0] , sizeof( PCMV2 ) );
		ZeroMemory( &PCMD[0] , sizeof( PCMD ) );
		ZeroMemory( &PCMF[0] , sizeof( PCMF ) );
		for( T=0 ; T<8 ; T++ ) PCMF[T] = 0xffff;
		ZeroMemory( &PCMF2[0] , sizeof( PCMF2 ) );
		ZeroMemory( &PCMN[0] , sizeof( PCMN ) );
		ZeroMemory( &PCMN2[0] , sizeof( PCMN2 ) );
		ZeroMemory( &PCMP[0] , sizeof( PCMP ) );
		ZeroMemory( &PCMP2[0] , sizeof( PCMP2 ) );
		ZeroMemory( &MPp[0] , sizeof( MPp ) );
		FMP = 0;

		CString			cMup = "";						//TvOf[^
		P = LP = 0;

		if( (cEr = FileR( pM , Mlen , 0x100000 , cFN )) != "" )
		{
			for( T=0 ; T<cEr.GetLength() ; T++ ) cEm[T] = cEr[T];
			return( 0 );
		}
		T = pM[P++];
		Mch = T &15;
		Mver = T >> 4;
		Mvol = pM[P++];
		Mvol += pM[P++] *256;
		Mve = pM[P++];
		Msel = pM[P++];
		Mvar = pM[P++];
		cTIT = "";
		for( T=0 ; T<42 ; T++ ) cTIT += (char)pM[P++];
		for( T=0 ; T<42 ; T+=2 )
		{
			int F1 = (BYTE)cTIT[T];
			int F2 = (BYTE)cTIT[T +1];
			int S = 0;
			if( F1 >= 0x81 && F1 <= 0x9f ) S = (F1 -0x81) *94 *2; 
			if( F1 >= 0xe0 && F1 <= 0xef ) S = (F1 -0xe0 +0x9f -0x81 +1) *94 *2;
			if( F2 >= 0x40 && F2 <= 0x7e ) S += F2 -0x40;
			if( F2 >= 0x80 && F2 <= 0xfc ) S += F2 -0x80 +0x7e -0x40 +1;
			for( int i=0 ; i<16 ; i++ )
			{
				int P = (23 *16 + i) *512 *3 +((T /2 +9) *8 +16) *3;
				int F = FONT[S *8 + i /2];
				for( int j=0 ; j<8 ; j++ )
				{
					CPY[P++] = 0;
					CPY[P++] = ((F &128) >> 7) *255;
					CPY[P++] = 0;
					F <<= 1;
				}
			}
		}
		for( T=40 ; T>=0 ; T-=2 )
		{
			if( (BYTE)cTIT[T] != 0x81 || (BYTE)cTIT[T +1] != 0x40 ) break;
		}
		cTIT = cTIT.Left( T +2 );
		for( T=0 ; T<8 ; T++ )
		{
			if( pM[P + T] == ' ' ) break;
			cMup += (char)pM[P + T];
		}
		P += 8;
		Msn = pM[P++];
		if( Msn )
		{
			for( T=cFN.GetLength() ; T>1 ; T-- )
			{
				if( cFN[T -1] == '\\' ) break;
			}
			cT = cFN.Left( T ) + cMup;
			if( (cEr = FileR( pMP , T , 0x100000 , cT +".mup" )) != "" )
			{
				for( T=0 ; T<cEr.GetLength() ; T++ ) cEm[T] = cEr[T];
				return( 0 );
			}
		}
		else pMP = &PSGN[0];

		T = 0;
		int R = 0;
		for( int i=0 ; i<Msn ; i++ )
		{
			MPl[i] = pM[P++];
			MPl[i] += pM[P++] *256;
			MPt[i] = 256 -11;
			if( Mver > 0 ) MPt[i] = pM[P++];
			MPf[i] = pM[P++];
			for( int j=0 ; j<4 ; j++ ) MPn[i][j] = pM[P++];
			if( i == 0 && SQWF != 0 && SQW[0] != 0 )
			{
				if( *(DWORD*)&MPn[i][0] == (DWORD)' CCS' || *(DWORD*)&MPn[i][0] == (DWORD)' ccs' )
				{
					for( int j=0 ; j<MPl[i] ; j++ )
					{
						for( int k=0 ; k<256 ; k++ ) pMP[j *256 + k] = (k &0x80) +0x40;
					}
				}
			}
			MPp[i] = T;
			for( int j=0 ; j<MPl[i] ; j++ )
			{
				MPm[T++] = R &255;
				MPm[T++] = R >> 8;
				R++;
			}
			for( int j=0 ; j<4 ; j++ ) MPm[T++] = 0xff;//I[ ffff
		}
		if( Mver >= 3 )
		{
			T = pM[P++];
			for( int i=0 ; i<T ; i++ )
			{
				int p = pM[P++];
				p += pM[P++] *256 -0x3000;
				MPm[p +0] = 0xfe;
				MPm[p +1] = pM[P++];
				MPm[p +2] = pM[P++];
			}
		}
		if( Mver >= 4 ) Msv = pM[P++];
		if( Mver >= 2 )
		{
			T = pM[P++];
			int L = 0;
			for( int i=0 ; i<T ; i++ )
			{
				int p = pM[P++];
				int s = pM[P++];
				s += pM[P++] *256 -0x6300;
				MDp[i] = s;
				MDl[i] = p;
				L += p;
			}
			for( int i=0 ; i<L ; i++ ) MDd[i] = pM[P++];
		}
		PS = P;
		GCMD( pM , P , -1 , 0 );
		return( 0 );
	}
	if( F < 0 )
	{
		if( fFM ) OPLL_delete( pFM1 );
		if( fFM ) OPLL_delete( pFM2 );
		fFM = 0;
		return( 0 );
	}
	LARGE_INTEGER QPF;			//QueryPerformanceFrequency
	if( !QueryPerformanceFrequency( &QPF ) ) return( 0 );
	double dT = 0.0;//Ԍv
	double WV1[810 *2],WV2[810 *2];
	int EF = 0;
	for( int ii=0 ; ii<F ; ii++ )
	{
		LARGE_INTEGER QPB,QPA;
		QueryPerformanceCounter( &QPB );

		int F1 = (int)((double)CT * (double)WRate / FRate);
		int F2 = (int)((double)(CT +1) * (double)WRate / FRate);
		int S1 = F2 - F1;
		int FF1 = (int)((double)(CT +2) * (double)WRate / FRate);
		int FF2 = (int)((double)(CT +3) * (double)WRate / FRate);
		int SS1 = FF2 - FF1;
		double dF3 = (double)CT * (double)15700 / FRate;
		double dF4 = (double)(CT +1) * (double)15700 / FRate;
		int S2 = (int)dF4 -(int)dF3;
		double dF5 = (double)CT * (double)49716 / FRate;
		double dF6 = (double)(CT +1) * (double)49716 / FRate;
		int S3 = (int)dF6 -(int)dF5;
		for( T=0 ; T<810 *2 ; T++ ) WV1[T] = WV2[T] = 0.0;
		for( T=0 ; T<400 ; T++ ) pWAVM1[(int)dF3 + T] = pWAVM2[(int)dF3 + T] = 0.0;
		{
			int X[8][2];
			while( true )
			{
fm:				if( FMP )
				{
					if( FMVC )
					{
						FMVC--;
						for( int i=0 ; i<FMP ; i++ )
						{
							X[i][0] = 1;
							X[i][1] = 0;
						}
						break;
					}
					else
					{
						T = GCM4( pM , P );
						if( T )
						{
							if( T < 8 )
							{
								FMVC = T -1;
								for( int i=0 ; i<FMP ; i++ )
								{
									X[i][0] = 1;
									X[i][1] = 0;
								}
								break;
							}
							else
							{
								T -= 7;
								for( int i=0 ; i<T ; i++ )
								{
									int D1 = GCM4( pM , P );
									int D2 = pM[P++];
									X[i][0] = FMX[0][D2];
									X[i][1] = FMX[1][D2] + D1;
								}
								for( int i=T ; i<FMP ; i++ )
								{
									X[i][0] = 1;
									X[i][1] = 0;
								}
								break;
							}
						}
						else
						{
							int C = pM[P++];
							if( C == 0 )
							{
								FMP = 0;
								break;
							}
							else
							{
								for( int i=0 ; i<FMP ; i++ )
								{
									if( C & 1 )
									{
										int D1 = GCM4( pM , P );
										int D2 = pM[P++];
										X[i][0] = FMX[0][D2];
										X[i][1] = FMX[1][D2] + D1;
									}
									else
									{
										X[i][0] = 1;
										X[i][1] = 0;
									}
									C >>= 1;
								}
								break;
							}
						}
					}
				}
				break;
			}
			for( int i=0 ; i<FMP ; i++ )
			{
				int F = X[i][0];
				int T = X[i][1];
				OPLL_writeReg( pFM1 , i +0x10 , F );
				OPLL_writeReg( pFM2 , i +0x10 , F );
				FM[i +0x10] = F;
				int S = 0x10;
				if( ((T &15) | F) == 0 ) S = 0;
				OPLL_writeReg( pFM1 , i +0x20 , (T >> 4) + S );
				OPLL_writeReg( pFM2 , i +0x20 , (T >> 4) + S );
				FM[i +0x20] = T >> 4;
				FMR[i] = 1;
				T = (Msv &0xf0) +15 -(T &15);
				OPLL_writeReg( pFM1 , i +0x30 , T );
				OPLL_writeReg( pFM2 , i +0x30 , T );
				FM[i +0x30] = T +0x100;
			}
		}
		while( true )
		{
			int C = GCMD( pM , P , 0 , 0 );
			if( C == 0xff ) break;
			if( C == 0xfe )
			{
				EF = 1;
				break;
			}
			if( C == 0xfd )
			{
				T = PS + GCMD( pM , P , 0 , 0 ) *16384;
				T += GCMD( pM , P , 0 , 0 );
				P =  T + GCMD( pM , P , 0 , 0 ) *256;
				if( LP++ < PLLPC ) continue;
				EF = 1;
				break;
			}
			if( C >= 0xa8 && C <= 0xab )//FM FEʃWX^ݒ
			{
				if( C == 0xa8 )
				{
					for( int i=0 ; i<8 ; i++ )
					{
						T = GCMD( pM , P , 0 , 0 );
						OPLL_writeReg( pFM1 , i , T );
						OPLL_writeReg( pFM2 , i , T );
					}
					continue;
				}
				if( C == 0xa9 ) Mvar = GCMD( pM , P , 0 , 0 );
				if( C == 0xaa ) Msel = GCMD( pM , P , 0 , 0 );
				if( C == 0xab ) Mrst = GCMD( pM , P , 0 , 0 );
				continue;
			}
			if( C >= 0xc8 && C <= 0xcf )//TvOiŒgj
			{
				T = C -0xc8;
				WVFX[T][0] = PCMD[T] = pM[P++];
				WVFX[T][1] = pM[P++];
				WVFX[T][2] = *(WORD*)&MPm[MPp[WVFX[T][1]]] *256;
				WVFX[T][3] = 0;
				WVFX[T][4] = MPf[WVFX[T][1]] *2;
				WVFX[T][5] = 0x8000;
				WVFX[T][6] = 0;
				continue;
			}
			if( C >= 0x40 && C <= 0x4f )//PSG
			{
				PSG[C -0x40] = GCMD( pM , P , 0 , 0 );
				if( C == 0x4d )
				{
					dPEP = 0.0;
					PSGF = 1;
				}
				continue;
			}
			if( C <= 0x3f )//FM
			{
				T = FM[C];
				FM[C] = GCMD( pM , P , 0 , 0 );
				if( C >= 0x20 && C <= 0x28 )
				{
					if( (T &0x10) == 0 && (FM[C] &0x10) == 0x10 ) FMR[C -0x20] = FMRP[C -0x20] = 1;
				}
				if( C >= 0x30 && C <= 0x38 )
				{
					if( (T &0x0f) != (FM[C] &0x0f) ) FMR[C -0x30] = 1;
				}
				OPLL_writeReg( pFM1 , C , FM[C] );
				OPLL_writeReg( pFM2 , C , FM[C] );
				continue;
			}
			if( (C >= 0xe0 && C <= 0xef) || (C >= 0x90 && C <= 0x9f) )//
			{
				int N = C -0xe0;
				if( C < 0x9f ) N = C -0x90 +0x10;
				if( C == 0x9f ) N = GCMD( pM , P , 0 , 0 );
				for( int i=0 ; i<MDl[N] ; i++ ) GCMD( pM , P , 1 , MDd[MDp[N] + i] );
				continue;
			}
			if( C >= 0xd8 && C <= 0xdf || C == 0xae )// FM
			{
				int N = C -0xd8 +1;
				if( C == 0xae ) N = 9;
				for( int i=0 ; i<N ; i++ )
				{
					int F = GCMD( pM , P , 0 , 0 );
					int T = GCMD( pM , P , 0 , 0 );
					OPLL_writeReg( pFM1 , i +0x10 , F );
					OPLL_writeReg( pFM2 , i +0x10 , F );
					FM[i +0x10] = F;
					int S = 0x10;
					if( ((T &15) | F) == 0 ) S = 0;
					OPLL_writeReg( pFM1 , i +0x20 , (T >> 4) + S );
					OPLL_writeReg( pFM2 , i +0x20 , (T >> 4) + S );
					FM[i +0x20] = T >> 4;
					FMR[i] = 1;
					T = (Msv &0xf0) +15 -(T &15);
					OPLL_writeReg( pFM1 , i +0x30 , T );
					OPLL_writeReg( pFM2 , i +0x30 , T );
					FM[i +0x30] = T +0x100;
				}
				continue;
			}
			if( C >= 0xd0 && C <= 0xd7 )// PCM
			{
				int VX[16] = {0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x08,0x0a,0x0d,0x11,0x16,0x1d,0x25,0x30,0x3f};
				int N = C -0xd0 +1;
				for( int i=0 ; i<N ; i++ )
				{
					int F = GCMD( pM , P , 0 , 0 );
					int T = GCMD( pM , P , 0 , 0 );
					PCMV[i] = PCMD[i] = VX[T &15];
					PCMF[i] = (F +(T >> 4) *256) *4;
					PCMN[i] = 0;
				}
				continue;
			}
			if( (C >= 0xa0 && C <= 0xa7) || (C >= 0xb0 && C <= 0xc7) )//TvO
			{
				int N = C &7;
				C &= 0xf8;
				if( C == 0xa0 )//TvO
				{
					PCMP2[N] = 0;//K{ireg 7f ̏sĂꍇj
					Mrst |= 1 << N;
					PCMV[N] = PCMD[N] = GCMD( pM , P , 0 , 0 );
					PCMN[N] = GCMD( pM , P , 0 , 0 );
					PCMF[N] = GCMD( pM , P , 0 , 0 );
					continue;
				}
				if( C == 0xb0 )//iĐj
				{
					PCMP2[N] = 0;//K{ireg 7f ̏sĂꍇj
					Mrst |= 1 << N;
					PCMV[N] = PCMD[N] = GCMD( pM , P , 0 , 0 );
					PCMN[N] = GCMD( pM , P , 0 , 0 );
					PCMF[N] = 128;
					continue;
				}
				if( C == 0xb8 )//iʕύXj
				{
					PCMV[N] = PCMD[N] = GCMD( pM , P , 0 , 0 );
					continue;
				}
				if( C == 0xc0 )//iύXj
				{
					PCMF[N] = GCMD( pM , P , 0 , 0 );
					continue;
				}
			}
			if( C >= 0x50 && C <= 0x8f )//ώg
			{
				int N = C &7;
				C &= 0xf8;
				if( C == 0x80 )
				{
					if( C == 0x88 ) Mrst |= 1 << N;
					PCMV[N] = PCMD[N] = GCMD( pM , P , 0 , 0 );
					PCMN[N] = GCMD( pM , P , 0 , 0 );
					T = GCMD( pM , P , 0 , 0 );
					PCMF[N] = GCMD( pM , P , 0 , 0 ) *256 + T;
					continue;
				}
				if( C == 0x50 )
				{
					PCMV[N] = PCMD[N] = GCMD( pM , P , 0 , 0 );
					continue;
				}
				if( C == 0x58 )
				{
					PCMN[N] = GCMD( pM , P , 0 , 0 );
					continue;
				}
				if( C == 0x60 )
				{
					T = GCMD( pM , P , 0 , 0 );
					PCMF[N] = GCMD( pM , P , 0 , 0 ) *256 + T;
					continue;
				}
				if( C == 0x68 )
				{
					T = GCMD( pM , P , 0 , 0 );
					PCMF[N] = GCMD( pM , P , 0 , 0 ) *256 + T;
					PCMV[N] = PCMD[N] = GCMD( pM , P , 0 , 0 );
					continue;
				}
				if( C == 0x70 )
				{
					PCMN[N] = GCMD( pM , P , 0 , 0 );
					PCMV[N] = PCMD[N] = GCMD( pM , P , 0 , 0 );
					continue;
				}
				if( C == 0x78 )
				{
					PCMN[N] = GCMD( pM , P , 0 , 0 );
					T = GCMD( pM , P , 0 , 0 );
					PCMF[N] = GCMD( pM , P , 0 , 0 ) *256 + T;
					continue;
				}
			}
			if( C == 0xad )//FM k
			{
				FMP = GCMD( pM , P , 0 , 0 );
				FMVC = 0;
				FMP4 = 0;
				goto fm;
			}
		}
		//PSG
		for( int i=0 ; i<3 ; i++ )
		{
			int V = PSG[i +8];
			if( V &0x10 ) V = 15;
			DIS[CT][i][4] = (V &15) *24 /15;
			T = -1;
			int N = PSG[i *2] +(PSG[i *2 +1] &15) *256;
			if( N )
			{
				double dQ = (double)3579545 /32.0 /(double)N;
				double dN = (double)log( dQ ) / (double)log( (double)1.0594630943592952645618252949463 ) -48.376316;
				T = (int)(dN +0.5);
			}
			WTN( T , &DIS[CT][i][0] );
			DIS[CT][i][5] = (T -12 +256) &255;
		}
		//FM
		if( FM[0x0e] &0x20 )
		{
			int Q[5][2];
			Q[0][0] = Q[0][1] = FM[0x36] &15;
			Q[1][0] = Q[1][1] = FM[0x37] >> 4;
			Q[2][0] = Q[2][1] = FM[0x37] &15;
			Q[3][0] = Q[3][1] = FM[0x38] >> 4;
			Q[4][0] = Q[4][1] = FM[0x38] &15;
			for( int i=0 ; i<5 ; i++ )
			{
				Q[i][0] += FMPAND[i][0];
				if( Q[i][0] < 0 ) Q[i][0] = 0;
				if( Q[i][0] > 15 ) Q[i][0] = 15;
				Q[i][1] += FMPAND[i][1];
				if( Q[i][1] < 0 ) Q[i][1] = 0;
				if( Q[i][1] > 15 ) Q[i][1] = 15;
			}
			OPLL_writeReg( pFM1 , 0x36 , Q[0][0] );
			OPLL_writeReg( pFM2 , 0x36 , Q[0][1] );
			OPLL_writeReg( pFM1 , 0x37 , Q[1][0] *16 + Q[2][0] );
			OPLL_writeReg( pFM2 , 0x37 , Q[1][1] *16 + Q[2][1] );
			OPLL_writeReg( pFM1 , 0x38 , Q[3][0] *16 + Q[4][0] );
			OPLL_writeReg( pFM2 , 0x38 , Q[3][1] *16 + Q[4][1] );
		}
		for( int i=0 ; i<9 ; i++ )
		{
			if( FM[0x0e] &0x20 )
			{
				if( i >= 6 )
				{
					WTN( -1 , &DIS[CT][i +3][0] );
					DIS[CT][i +3][4] = 0;
					DIS[CT][i +3][5] = -1;
					continue;
				}
			}
			if( FMRP[i] )
			{
				FMRP[i] = 0;
				FMRN[i] = (FM[i +0x30] >> 4) &15;
			}

			T = (FM[i +0x30] &15) + FMPAN[FMRN[i]][0];
			if( T < 0 ) T = 0;
			if( T > 15 ) T = 15;
			if( FM[i +0x30] < 0x100 )
			{
				if( SQWF != 0 && SQW[1] != 0 ) OPLL_writeReg( pFM1 , i +0x30 , 0x50 + T );
				else OPLL_writeReg( pFM1 , i +0x30 , (FM[i +0x30] &0xf0) + T );
			}
			T = (FM[i +0x30] &15) + FMPAN[FMRN[i]][1];
			if( T < 0 ) T = 0;
			if( T > 15 ) T = 15;
			if( FM[i +0x30] < 0x100 )
			{
				if( SQWF != 0 && SQW[1] != 0 && FM[i +0x30] >= 0 ) OPLL_writeReg( pFM2 , i +0x30 , 0x50 + T );
				else OPLL_writeReg( pFM2 , i +0x30 , (FM[i +0x30] &0xf0) + T );
			}

			if( FMR[i] )
			{
				FMR[i] = 0;
				FMV[i] = (15 -(FM[i +0x30] &15)) *4;
			}
			DIS[CT][i +3][4] = FMV[i] *24 /60;
			if( FMV[i] ) FMV[i]--;
			int N = FM[i +0x10] +(FM[i +0x20] &1) *256;
			int F = (FM[i +0x20] >> 1) &7;
			double dQ = (double)N *3579545 /72.0 /524288 * (1 << F);
			T = -1;
			if( dQ > 12.0 )
			{
				double dN = (double)log( dQ ) / (double)log( (double)1.0594630943592952645618252949463 ) -48.376316;
				T = (int)(dN +0.5);
			}
			WTN( T , &DIS[CT][i +3][0] );
			DIS[CT][i +3][5] = (T -12 +256) &255;
		}

		for( int j=0 ; j<8 ; j++ )
		{
			DIS[CT][12 + j][4] = (PCMD[j] &63) *24 /63;
			int B = 1 << j;
			if( Msel & B )
			{
				if( Mrst & B )
				{
					for( T=0 ; T<8 ; T++ ) WV24[j][T] = 0x8000;
					Mrst ^= B;
				}
				for( T=0 ; T<4 ; T++ ) DIS[CT][j +12][T] = '-';
				DIS[CT][j +12][5] = -1;
				if( PCMD[j] )
				{
					for( T=0 ; T<4 ; T++ ) DIS[CT][12 + j][T] = MPn[WVFX[j][1]][T];
					DIS[CT][12 + j][5] = 0;
				}
				int EPF[400];
				for( T=0 ; T<8 ; T++ ) EPF[T] = WV24[j][T];
				if( WVFX[j][4] &0x100 )//2bit
				{
					BYTE* pP = pMP + WVFX[j][2];
					int V = WVFX[j][0];
					int MP = WVFX[j][3];
					int TP = WVFX[j][4] &255;
					int P = WVFX[j][5];
					int R = MPl[WVFX[j][1]] *256 *4;
					int Q = WVFX[j][6];
					if( Q < 0x40000000 )
					{
						DataRestore2( S2 , &EPF[8] , pP , MP , P , TP );
						WVFX[j][2] = (int)(pP - pMP);
						WVFX[j][3] = MP;
						WVFX[j][4] = TP +0x100;
						WVFX[j][5] = P;
					}
					for( T=0 ; T<S2 ; T++ )
					{
						if( Q++ >= R )
						{
							EPF[T +8] = 0x8000;
							Q = 0x40000000;
						}
						EPF[T +8] = ((EPF[T +8] -0x8000) * V >> 6) +0x8000;
					}
					WVFX[j][6] = Q;
				}
				else
				{//4bit
					BYTE* pP = pMP + WVFX[j][2];
					int V = WVFX[j][0];
					int MP = WVFX[j][3];
					int TP = WVFX[j][4];
					int P = WVFX[j][5];
					int R = MPl[WVFX[j][1]] *256 *2;
					int Q = WVFX[j][6];
					if( Q < 0x40000000 )
					{
						DataRestore4( S2 , &EPF[8] , pP , MP , P , TP );
						WVFX[j][2] = (int)(pP - pMP);
						WVFX[j][3] = MP;
						WVFX[j][4] = TP;
						WVFX[j][5] = P;
					}
					for( T=0 ; T<S2 ; T++ )
					{
						if( Q++ >= R )
						{
							EPF[T +8] = 0x8000;
							Q = 0x40000000;
						}
						EPF[T +8] = ((EPF[T +8] -0x8000) * V >> 6) +0x8000;
					}
					WVFX[j][6] = Q;
				}
				double dV1 = (double)PCMPAN[j][0] /100.0;
				double dV2 = (double)PCMPAN[j][1] /100.0;
				for( T=0 ; T<8 ; T++ ) WV24[j][T] = EPF[S2 + T];
				T = EPF[7 + S2];
				for( int k=6 ; k>=0 ; k-- ) T = (T + EPF[k + S2]) /2;
				for( int k=S2 -1 ; k>=0 ; k-- )
				{
					T += EPF[k];
					pWAVM1[(int)dF3 + k] += (double)(T -0x8000 -0x8000) * dV1;
					pWAVM2[(int)dF3 + k] += (double)(T -0x8000 -0x8000) * dV2;
					T = T /2;
				}
			}
			else
			{
				if( Mvar & B )
				{
					if( Mrst & B )
					{
						PCMP2[j] = 0;
						Mrst ^= B;
					}
					if( PCMD[j] ) PCMD[j]--;
					{//\
						for( T=0 ; T<4 ; T++ ) DIS[CT][j +12][T] = '-';
						DIS[CT][j +12][5] = -1;
						if( PCMF[j] < 0xffff ) for( T=0 ; T<4 ; T++ ) DIS[CT][j +12][T] = MPn[PCMN[j]][T];
						double dQ = (double)3579545 *2.0 /456.0 /32768.0 * (double)PCMF[j];
						T = -1;
						if( dQ > 0.0 && dQ < 7847.0 )
						{
							double dN = (double)log( dQ ) / (double)log( (double)1.0594630943592952645618252949463 ) -48.376316;
							T = (int)(dN +0.5);
						}
						if( T >= 0 ) DIS[CT][j +12][5] = (MPt[PCMN[j]] + T -12 +256) &255;
						if( PCMV[j] == 0 ) DIS[CT][j +12][5] = -1;
					}
					double dV = 4.0 * (double)Mvol /(double)0x800 /256.0 * (double)VPCM /100.0;//
					double dV1 = dV * (double)PCMPAN[j][0] /100.0;
					double dV2 = dV * (double)PCMPAN[j][1] /100.0;
					int V = PCMV[j];
					int N = MPp[PCMN[j]];
					int Q = PCMF[j] *2;
					long long int P = PCMP2[j];
					int R = 0;
					if( Q != 0 ) R = (int)((double)Q * (double)3579545 *2.0 /456.0 / (double)WRate /2.0 *256.0 +0.5);
					int F = 1;
					if( P < 0 )
					{
						P = V = R = F = 0;
					}
					for( int k=0 ; k<SS1 *2 ; k++ )
					{
						T = (int)(P >> 8);
						int S1 = T >> 8;
						int E = T &255;
						int S2 = S1 >> 8;
						int S3 = (S1 +1) >> 8;
						int A = *(WORD*)&MPm[N + S2 *2];
						if( A >= 0xfeff )
						{
							if( A == 0xffff ) P = V = A = F = 0;
							if( A == 0xfeff )
							{
								A = S2 +((*(WORD*)&MPm[N + S2 *2 +2] -0x10000 +3) >> 1);
								P = (P &65535) +(long long int)A *65536 *256;
								A += N;
							}
						}
						int B = *(WORD*)&MPm[N + S3 *2];
						if( B >= 0xfeff )
						{
							if( B == 0xffff ) P = V = B = F = 0;
							if( B == 0xfeff )
							{
								B = S3 +((*(WORD*)&MPm[N + S3 *2 +2] -0x10000 +3) >> 1);
								P = (P &65535) +(long long int)B *65536 *256;
								B += N;
							}
						}
						WV1[k] += (double)((pMP[A *256 +(S1 &255)] -0x80) * (256 - E) +(pMP[B *256 +((S1 +1) &255)] -0x80) * E) * dV1 * (double)V;
						WV2[k] += (double)((pMP[A *256 +(S1 &255)] -0x80) * (256 - E) +(pMP[B *256 +((S1 +1) &255)] -0x80) * E) * dV2 * (double)V;
						P += (long long int)R;
					}
					if( F == 0 ) P = -1;
					PCMP2[j] = P;
				}
				else
				{
					if( Mrst & B )
					{
						PCMP[j] = 0;
						PCMV2[j] = PCMV[j];
						PCMF2[j] = PCMF[j];
						PCMN2[j] = PCMN[j];
						Mrst ^= B;
					}
					{//\
						double dQ = (double)3579545 *2.0 /456.0 /32768.0 * (double)PCMF[j];
						T = -1;
						if( dQ > 12.0 && dQ < 7847.0 )
						{
							double dN = (double)log( dQ ) / (double)log( (double)1.0594630943592952645618252949463 ) -48.376316;
							T = (int)(dN +0.5);
						}
						WTN( T , &DIS[CT][j +12][0] );
						DIS[CT][j +12][5] = (T -12 +256) &255;
					}
					double dV = 4.0 * (double)Mvol /(double)0x800 /256.0 * (double)VPCM /100.0;//
					double dV1 = dV * (double)PCMPAN[j][0] /100.0;
					double dV2 = dV * (double)PCMPAN[j][1] /100.0;
					int V = PCMV2[j] &63;
					int V2 = PCMV[j] &63;
					if( PCMV2[j] &0x40 ) V2 = (V2 + V) >> 1;
					int N = PCMN2[j];
					int Q = PCMF2[j];
					int P = PCMP[j];
					double dQ = (double)3579545 *2.0 /456.0 /32768.0 * (double)Q;
					double dQ2 = (double)3579545 *2.0 /456.0 /32768.0 * (double)PCMF[j];
					int R = 0,R2 = 0;
					if( dQ != 0.0 ) R = (int)(dQ / (double)WRate /2.0 *65536.0 +0.5);
					if( dQ2 != 0.0 ) R2 = (int)(dQ2 / (double)WRate /2.0 *65536.0 +0.5);
					if( P == 0 ) P = 65536;
					int F = 0;
					for( int k=0 ; k<SS1 ; k++ )
					{
						if( F == 0 )
						{
							if( P >= 65536 )
							{
								F = 1;
								V = V2;
								N = PCMN[j];
								Q = PCMF[j];
								R = R2;
							}
							T = (P >> 8) &255;
							int E = P &255;
							WV1[k] += (double)((pMP[N *256 + T] -0x80) * (256 - E) +(pMP[N *256 +((T +1) &255)] -0x80) * E) * dV1 * (double)V;
							WV2[k] += (double)((pMP[N *256 + T] -0x80) * (256 - E) +(pMP[N *256 +((T +1) &255)] -0x80) * E) * dV2 * (double)V;
							P += R;
						}
						else
						{
							T = (P >> 8) &255;
							int E = P &255;
							WV1[k] += (double)((pMP[N *256 + T] -0x80) * (256 - E) +(pMP[N *256 +((T +1) &255)] -0x80) * E) * dV1 * (double)V;
							WV2[k] += (double)((pMP[N *256 + T] -0x80) * (256 - E) +(pMP[N *256 +((T +1) &255)] -0x80) * E) * dV2 * (double)V;
							P = (P + R) &65535;
						}
					}
					V2 = PCMV[j] &63;
					F = 0;
					for( int k=SS1 ; k<SS1 *2 ; k++ )
					{
						if( F == 0 )
						{
							if( P >= 65536 )
							{
								F = 1;
								V = V2;
								N = PCMN[j];
								Q = PCMF[j];
								R = R2;
							}
							T = (P >> 8) &255;
							int E = P &255;
							WV1[k] += (double)((pMP[N *256 + T] -0x80) * (256 - E) +(pMP[N *256 +((T +1) &255)] -0x80) * E) * dV1 * (double)V;
							WV2[k] += (double)((pMP[N *256 + T] -0x80) * (256 - E) +(pMP[N *256 +((T +1) &255)] -0x80) * E) * dV2 * (double)V;
							P += R;
						}
						else
						{
							T = (P >> 8) &255;
							int E = P &255;
							WV1[k] += (double)((pMP[N *256 + T] -0x80) * (256 - E) +(pMP[N *256 +((T +1) &255)] -0x80) * E) * dV1 * (double)V;
							WV2[k] += (double)((pMP[N *256 + T] -0x80) * (256 - E) +(pMP[N *256 +((T +1) &255)] -0x80) * E) * dV2 * (double)V;
							P = (P + R) &65535;
						}
					}
					PCMP[j] = P;
					PCMV2[j] = V;
					PCMN2[j] = N;
					PCMF2[j] = Q;
				}
			}
		}
		CopyMemory( &WVT1[CT &3][0] , &WV1[0] , sizeof( WV1 ) );
		CopyMemory( &WVT2[CT &3][0] , &WV2[0] , sizeof( WV2 ) );
		CopyMemory( &WV1[0] , &WVT1[(CT +2) &3][0] , sizeof( WV1 ) );
		CopyMemory( &WV2[0] , &WVT2[(CT +2) &3][0] , sizeof( WV2 ) );
		{
			double dV = (double)Mvol /(double)0x800 * (double)VPCM /100.0;//
			for( int j=0 ; j<S1 *2 ; j++ )//pcm
			{
				double dT = dF3 + j * (dF4 - dF3) /(double)(S1 *2);
				T = (int)dT;
				double dP = dT -(double)T;
				WV1[j] += (pWAVM1[T -262 *2] * (1.0 - dP) + pWAVM1[T - 262 *2 +1] * dP) * dV;
				WV2[j] += (pWAVM2[T -262 *2] * (1.0 - dP) + pWAVM2[T - 262 *2 +1] * dP) * dV;
			}
		}
		for( int j=0 ; j<S3 ; j++ )//ym2413
		{
			pWAVY1[(int)dF5 + j] = OPLL_calc( pFM1 );
			pWAVY2[(int)dF5 + j] = OPLL_calc( pFM2 );
		}
		{
			double dV = 4.0 * (double)VFM /100.0;
			for( int j=0 ; j<S1 *2 ; j++ )//ym2413
			{
				double dT = dF5 + j * (dF6 - dF5) /(double)(S1 *2);
				T = (int)dT;
				double dP = dT -(double)T;
				WV1[j] += ((double)pWAVY1[T -2] * (1.0 - dP) + (double)pWAVY1[T -1] * dP) * dV;//
				WV2[j] += ((double)pWAVY2[T -2] * (1.0 - dP) + (double)pWAVY2[T -1] * dP) * dV;//
			}
		}
		double dPEPT = dPEP;//Gx[vʒuۑ
		for( int k=0 ; k<3 ; k++ )//psg
		{
			dPEP = dPEPT;
			int F = (PSG[7] >> k) &9;
			int V = PSG[k +8];
			int EP = 0;
			if( V &0x10 )
			{
				if( PSGF ) PSGP[k] = 0.0;
				V = 15;
				EP = 1;
			}
			T = PSG[11] + PSG[12] *256;
			if( T == 0 ) T = 1;
			double dE = (double)4096.0 /((double)T * 16.0 /((double)3579545 /32.0) * (double)WRate * 2.0);
			BYTE* pP = &PSGEV[PSG[13] &15][0];
			double dP = PSGP[k];
			double dV = PSGV[V &15] *57 * (double)VPSG /100.0;//
			int N = PSG[k *2] +(PSG[k *2 +1] &15) *256;
			double dQ,dR;
			if( N < 3 )
			{
				dQ = dR = 0.0;
//				if( (F &1) == 1 ) dV *= 2.0;
			}
			else
			{
                dQ = (double)3579545 /32.0 /(double)N;
				dR = dQ / (double)WRate /2.0;
			}
			int NT = PSG[6] &31;
			if( NT == 0 ) NT = 1;
			double dP2 = PSGNP[k];
			double dQ2 = (double)3579545 /32.0 /(double)NT;
			double dR2 = dQ2 / (double)WRate /2.0;
			double dV1 = dV * (double)PSGPAN[k][0] /100.0;
			double dV2 = dV * (double)PSGPAN[k][1] /100.0;
			if( F == 8 )
			{
				for( int j=0 ; j<S1 *2 ; j++ )
				{
					T = (int)dPEP;
					if( T >= 16384 ) T = (T &8191) +8192;
					double dT = dP - (double)((int)dP);
					if( EP )
					{
						if( dT < 0.5 )
						{
							WV1[j] -= dV1 * (double)pP[T] /256.0;
							WV2[j] -= dV2 * (double)pP[T] /256.0;
						}
						else
						{
							WV1[j] += dV1 * (double)pP[T] /256.0;
							WV2[j] += dV2 * (double)pP[T] /256.0;
						}
					}
					else
					{
						if( dT < 0.5 )
						{
							WV1[j] -= dV1;
							WV2[j] -= dV2;
						}
						else
						{
							WV1[j] += dV1;
							WV2[j] += dV2;
						}
					}
					dP = dT + dR;
					dP2 += dR2;
					dPEP += dE;
				}
				PSGP[k] = dP;
				PSGNP[k] = dP2 -(double)((int)(dP2 /131072.0) *131072);
			}
			if( F == 1 )
			{
				for( int j=0 ; j<S1 *2 ; j++ )
				{
					T = (int)dPEP;
					if( T >= 16384 ) T = (T &8191) +8192;
					if( EP )
					{
						if( PSGN[(int)dP2 &131071] )
						{
							WV1[j] -= dV1 * (double)pP[T] /256.0;
							WV2[j] -= dV2 * (double)pP[T] /256.0;
						}
						else
						{
							WV1[j] += dV1 * (double)pP[T] /256.0;
							WV2[j] += dV2 * (double)pP[T] /256.0;
						}
					}
					else
					{
						if( PSGN[(int)dP2 &131071] )
						{
							WV1[j] -= dV1;
							WV2[j] -= dV2;
						}
						else
						{
							WV1[j] += dV1;
							WV2[j] += dV2;
						}
					}
					dP2 += dR2;
					dPEP += dE;
				}
				PSGNP[k] = dP2 -(double)((int)(dP2 /131072.0) *131072);
			}
			if( F == 0 )
			{
				for( int j=0 ; j<S1 *2 ; j++ )
				{
					T = (int)dPEP;
					if( T >= 16384 ) T = (T &8191) +8192;
					double dT = dP - (double)((int)dP);
					if( EP )
					{
						if( dT < 0.5 )
						{
							if( PSGN[(int)dP2 &131071] )
							{
								WV1[j] -= dV1 * (double)pP[T] /256.0;
								WV2[j] -= dV2 * (double)pP[T] /256.0;
							}
							else
							{
								WV1[j] += dV1 * (double)pP[T] /256.0;
								WV2[j] += dV2 * (double)pP[T] /256.0;
							}
						}
						else
						{
							WV1[j] += dV1 * (double)pP[T] /256.0;
							WV2[j] += dV2 * (double)pP[T] /256.0;
						}
					}
					else
					{
						if( dT < 0.5 )
						{
							if( PSGN[(int)dP2 &131071] )
							{
								WV1[j] -= dV1;
								WV2[j] -= dV2;
							}
							else
							{
								WV1[j] += dV1;
								WV2[j] += dV2;
							}
						}
						else
						{
							WV1[j] += dV1;
							WV2[j] += dV2;
						}
					}
					dP = dT + dR;
					dP2 += dR2;
					dPEP += dE;
				}
				PSGP[k] = dP;
				PSGNP[k] = dP2 -(double)((int)(dP2 /131072.0) *131072);
			}
			if( F == 9 )//
			{
				for( int j=0 ; j<S1 *2 ; j++ )
				{
					T = (int)dPEP;
					if( T >= 16384 ) T = (T &8191) +8192;
					double dT = dP - (double)((int)dP);
					if( EP )
					{
						if( dT < 0.5 )
						{
							WV1[j] -= dV1 * (double)pP[T] /256.0;
							WV2[j] -= dV2 * (double)pP[T] /256.0;
						}
						else
						{
							WV1[j] += dV1 * (double)pP[T] /256.0;
							WV2[j] += dV2 * (double)pP[T] /256.0;
						}
					}
					else
					{
					}
					dP = dT + dR;
					dP2 += dR2;
					dPEP += dE;
				}
				PSGP[k] = dP;
				PSGNP[k] = dP2 -(double)((int)(dP2 /131072.0) *131072);
			}
			if( dPEP >= 8192.0 ) dPEP -= (double)((int)(dPEP /8192) *8192) -8192;
			PSGF = 0;
		}
		double dVOL = (double)VOL;
		if( CT >= FDTST *60 )
		{
			dVOL *= (double)(FDTED *60 -1 - (CT - FDTST *60)) / (double)(FDTED *60);
		}
		for( int j=0 ; j<S1 ; j++ )//
		{
			T = (int)((WV1[j *2] + WV1[j *2 +1]) * dVOL /200.0);
			if( T > 0x7fff ) T = 0x7fff;
			if( T < -0x8000 ) T = 0x8000;
			*(WORD*)&WAVF[(F1 + j) *4 +0x2c] = T;

			T = (int)((WV2[j *2] + WV2[j *2 +1]) * dVOL /200.0);
			if( T > 0x7fff ) T = 0x7fff;
			if( T < -0x8000 ) T = 0x8000;
			*(WORD*)&WAVF[(F1 + j) *4 +2 +0x2c] = T;
		}
		QueryPerformanceCounter( &QPA );
		dT = (double)((QPA.QuadPart - QPB.QuadPart) *1000000 / QPF.QuadPart);
		if( EF ) break;
		if( ++CT >= PEND )//I
		{
			EF = 1;
			break;
		}
	}
	if( EF )
	{
		OPLL_delete( pFM1 );
		OPLL_delete( pFM2 );
		fFM = 0;
		return( 0 );
	}
	else return( (int)dT );
}


void CMuWinDlg::On_F0()
{
	DISF = 0;
}

void CMuWinDlg::On_F1()
{
	DISF = 1;
}

void CMuWinDlg::On_F2()
{
	DISF = 2;
}

void CMuWinDlg::On_F3()
{
	DISF = 3;
}

void CMuWinDlg::On_F4()
{
	DISF = 4;
}

void CMuWinDlg::On_F5()
{
	DISF = 5;
}

void CMuWinDlg::On_F6()
{
	DISF = 6;
}

void CMuWinDlg::OnCol()
{
	COL = (COL +1) %3;
	PTS( GetDlgItem( IDC_PIC ) );
}

BOOL CMuWinDlg::PreTranslateMessage(MSG* pMsg)
{
	// TODO : ɓȃR[hǉ邩A͊{NXĂяoĂB
	if( WM_KEYDOWN == pMsg->message )
	{
		switch( pMsg->wParam )
		{
			case VK_RETURN:
				return FALSE;
			case VK_ESCAPE:
				return FALSE;
			default:
				break;
		}
	}

	return CDialog::PreTranslateMessage(pMsg);
}
